package com.xebialabs.deployit.repository.sql.persisters

import com.xebialabs.deployit.core.sql.{ColumnName, SchemaInfo, TableName}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Environment
import com.xebialabs.deployit.repository.sql.specific.configurable.{ConfigurableTypeSpecificPersisterFactory, TypeConfiguration}
import com.xebialabs.deployit.repository.sql.specific.tables.{ListCiPropertyTable, SetCiPropertyTable}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class EnvironmentPersisterFactory (@Autowired @Qualifier("mainJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                                   @Autowired @Qualifier("mainSchema") implicit val mainSchemaInfo: SchemaInfo)
  extends ConfigurableTypeSpecificPersisterFactory(classOf[Environment]) {
  override val config = new TypeConfiguration(
    None,
    Map(
      "members" -> {
        import EnvironmentMembersSchema._
        new SetCiPropertyTable(tableName, environment_id, member_id)
      },
      "dictionaries" -> {
        import EnvironmentDictionariesSchema._
        new ListCiPropertyTable(tableName, environment_id, idx, dictionary_id)
      }
    )
  )
}

object EnvironmentMembersSchema {
  val tableName = TableName("XLD_ENVIRONMENT_MEMBERS")

  val environment_id = ColumnName("environment_id")
  val member_id = ColumnName("member_id")
}

object EnvironmentDictionariesSchema {
  val tableName = TableName("XLD_ENVIRONMENT_DICTIONARIES")

  val environment_id = ColumnName("environment_id")
  val idx = ColumnName("idx")
  val dictionary_id = ColumnName("dictionary_id")
}
