package ai.digital.deploy.sql.model

import com.fasterxml.jackson.annotation.JsonInclude
import jakarta.xml.bind.annotation.XmlTransient

import java.util.Date


class UserTokens {
  private var createdDate: Date = _
  private var lastUsedDate: Date = _
  private var expiryDate: Date = _
  private var tokenNote: String = _

  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @XmlTransient
  private var token: String = _
  private var ciId: Integer = _

  def this(createdDate: Date, lastUsedDate: Date, expiryDate: Date, tokenNote: String, ciId: Integer) {
    this()
    this.createdDate = createdDate
    this.lastUsedDate = lastUsedDate
    this.expiryDate = expiryDate
    this.tokenNote = tokenNote
    this.ciId = ciId
  }

  def this(createdDate: Date, lastUsedDate: Date, expiryDate: Date, tokenNote: String, token: String, ciId: Integer) {
    this(createdDate, lastUsedDate, expiryDate, tokenNote, ciId)
    this.token = token
  }

  def getCreatedDate: Date = createdDate

  def setCreatedDate(createdDate: Date): Unit = this.createdDate = createdDate

  def getLastUsedDate: Date = lastUsedDate

  def setLastUsedDate(lastUsedDate: Date): Unit = this.lastUsedDate = lastUsedDate

  def getExpiryDate: Date = expiryDate

  def setExpiryDate(expiryDate: Date): Unit = this.expiryDate = expiryDate

  def getTokenNote: String = tokenNote

  def setTokenNote(tokenNote: String): Unit = this.tokenNote = tokenNote

  def getCiId: Integer = ciId

  def setCiId(ciId: Integer): Unit = this.ciId = ciId

  def getToken: String = token

  def setToken(token: String): Unit = this.token = token

  override def toString: String = {
    s"UserTokens(createdDate=$createdDate, lastUsedDate=$lastUsedDate, expiryDate=$expiryDate, tokenNote=$tokenNote," +
      (if (token != null) s" token=$token," else "") +
      s" ciId=$ciId)"
  }
}
