package ai.digital.deploy.sql.model

import com.xebialabs.xlplatform.documentation.PublicApiRef
import jakarta.xml.bind.annotation.XmlRootElement


/**
  * Provides placeholder information: whether it is encrypted; if not, and the user has read access, then provides its value; and
  * gives a reference to the dictionary that defines it.
  */
@XmlRootElement
@PublicApiRef class DictionaryWithValueView() // called internally
{
  private var value: String = _
  private var encrypted = false
  private var dictionary: DefinedPlaceholderReference = _

  def this(value: String, encrypted: Boolean, dictionary: DefinedPlaceholderReference) {
    this()
    this.value = value
    this.encrypted = encrypted
    this.dictionary = dictionary
  }

  def getValue: String = value

  def setValue(value: String): Unit = {
    this.value = value
  }

  def isEncrypted: Boolean = encrypted

  def setEncrypted(encrypted: Boolean): Unit = {
    this.encrypted = encrypted
  }

  def getDictionary: DefinedPlaceholderReference = dictionary

  def setDictionary(dictionary: DefinedPlaceholderReference): Unit = {
    this.dictionary = dictionary
  }

  override def toString: String = "DictionaryWithValueView{" + "value='" + value + '\'' + ", encrypted='" + encrypted + '\'' + ", dictionary=" + dictionary + '}'
}
