package ai.digital.deploy.sql.model

import com.xebialabs.xlplatform.documentation.PublicApiRef
import jakarta.xml.bind.annotation.XmlRootElement


/**
  * Contains information about resolved placeholders: its key, its value (if readable), whether the value is from an encrypted
  * dictionary, which dictionary it is from, and to which containers, deployed application, and environment it is restricted
  */
@XmlRootElement
@PublicApiRef class ResolvedPlaceholderView() // Don't remove, it's used implicitly
{
  private var encrypted = false
  private var key: String = _
  private var value: String = _
  private var container: ResolvedPlaceholderReference = _
  private var deployedApp: ResolvedPlaceholderReference = _
  private var dictionary: ResolvedPlaceholderReference = _
  private var environment: ResolvedPlaceholderReference = _
  private var versionId: String = _

  def this(isEncrypted: Boolean, key: String, value: String, container: ResolvedPlaceholderReference, deployedApp: ResolvedPlaceholderReference, dictionary: ResolvedPlaceholderReference, environment: ResolvedPlaceholderReference, versionId: String) {
    this()
    this.encrypted = isEncrypted
    this.key = key
    this.value = value
    this.container = container
    this.deployedApp = deployedApp
    this.dictionary = dictionary
    this.environment = environment
    this.versionId = versionId
  }

  def getEncrypted: Boolean = encrypted

  def setEncrypted(enc: Boolean): Unit = {
    encrypted = enc
  }

  def getKey: String = key

  def setKey(key: String): Unit = {
    this.key = key
  }

  def getValue: String = value

  def setValue(value: String): Unit = {
    this.value = value
  }

  def getContainer: ResolvedPlaceholderReference = container

  def setContainer(container: ResolvedPlaceholderReference): Unit = {
    this.container = container
  }

  def getDeployedApp: ResolvedPlaceholderReference = deployedApp

  def setDeployedApp(deployedApp: ResolvedPlaceholderReference): Unit = {
    this.deployedApp = deployedApp
  }

  def getDictionary: ResolvedPlaceholderReference = dictionary

  def setDictionary(dictionary: ResolvedPlaceholderReference): Unit = {
    this.dictionary = dictionary
  }

  def getEnvironment: ResolvedPlaceholderReference = environment

  def setEnvironment(environment: ResolvedPlaceholderReference): Unit = {
    this.environment = environment
  }

  def getVersionId: String = versionId

  def setVersionId(versionId: String): Unit = {
    this.versionId = versionId
  }

  override def toString: String = "ResolvedPlaceholderView{" + "encrypted=" + encrypted + ", key='" + key + '\'' + ", value='" + value + '\'' + ", container=" + container + ", deployedApp=" + deployedApp + ", dictionary=" + dictionary + ", environment=" + environment + ", versionId='" + versionId + '\'' + '}'
}
