package ai.digital.deploy.sql.model

import org.apache.pekko.actor.AddressFromURIString

import jakarta.xml.bind.annotation.XmlRootElement


@XmlRootElement
class WorkerInfo() {
  private var id = 0
  private var name: String = _
  private var address: String = _
  private var local = false
  private var state: String = _
  private var controlTasks = 0
  private var deploymentTasks = 0

  def getId: Int = id

  def getName: String = name

  def getAddress: String = address

  def isLocal: Boolean = local

  def getState: String = state

  def getControlTasks: Int = controlTasks

  def getDeploymentTasks: Int = deploymentTasks

  def setId(id: Int): Unit = {
    this.id = id
  }

  def setName(name: String): Unit = {
    this.name = name
  }

  def setAddress(address: String): Unit = {
    this.address = address
  }

  def setLocal(local: Boolean): Unit = {
    this.local = local
  }

  def setState(state: String): Unit = {
    this.state = state
  }

  def setControlTasks(controlTasks: Int): Unit = {
    this.controlTasks = controlTasks
  }

  def setDeploymentTasks(deploymentTasks: Int): Unit = {
    this.deploymentTasks = deploymentTasks
  }

  def this(id: Int, name: String, address: String, state: String, deploymentTasks: Int, controlTasks: Int) {
    this()
    this.id = id
    this.name = name
    this.address = address
    this.local = AddressFromURIString.parse(address).hasLocalScope
    this.state = state
    this.deploymentTasks = deploymentTasks
    this.controlTasks = controlTasks
  }

  override def toString: String = "WorkerInfo{" + "id=" + id +
    ", name='" + name + '\'' + ", address='" + address + '\'' + ", local=" +
    local + ", state='" + state + '\'' + ", controlTasks=" + controlTasks + ", deploymentTasks=" +
    deploymentTasks + '}'
}
