package ai.digital.deploy.sql.model

import com.xebialabs.xlplatform.documentation.PublicApiRef
import jakarta.xml.bind.annotation.XmlRootElement


/**
  * A reference to a dictionary: its ID and its CI type.
  */
@XmlRootElement
@PublicApiRef
class DefinedPlaceholderReference() {
  private var id: String = _
  private var ciType: String = _

  def this(id: String, ciType: String) {
    this()
    this.id = id
    this.ciType = ciType
  }

  def getId: String = id

  def setId(id: String): Unit = {
    this.id = id
  }

  def getCiType: String = ciType

  def setCiType(ciType: String): Unit = {
    this.ciType = ciType
  }

  override def toString: String = "DefinedPlaceholderReference{" + "id='" + id + '\'' + ", ciType=" + ciType + '}'
}
