package ai.digital.deploy.sql.model

import javax.xml.bind.annotation.XmlRootElement


/**
  * General reference holder for resolved placeholders. Pointer to a CI, whether it exists and whether the user has read access to it.
  */
@XmlRootElement
class ResolvedPlaceholderReference() {
  private var id: String = _
  private var canRead = false
  private var exists = false

  def this(id: String, canRead: Boolean, exists: Boolean) {
    this()
    this.id = id
    this.canRead = canRead
    this.exists = exists
  }

  def getId: String = id

  def setId(id: String): Unit = {
    this.id = id
  }

  def getCanRead: Boolean = canRead

  def setCanRead(canRead: Boolean): Unit = {
    this.canRead = canRead
  }

  def getExists: Boolean = exists

  def setExists(exists: Boolean): Unit = {
    this.exists = exists
  }

  override def toString: String = "ResolvedPlaceholderReference{" + "id='" + id + '\'' + ", canRead=" + canRead + ", exists=" + exists + '}'
}
