package com.xebialabs.deployit.core.upgrade.service

import com.xebialabs.deployit.core.sql.batch.{BatchCommand, BatchExecutorRepository}
import com.xebialabs.deployit.core.sql.spring.XlSingleColumnRowMapper
import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo}
import com.xebialabs.deployit.core.upgrade.service.CISSchema.{idColumn, referenceIdColumn, tableName}
import com.xebialabs.deployit.repository.sql.base.CiPKType
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component
import org.springframework.transaction.PlatformTransactionManager
import org.springframework.transaction.annotation.Transactional

import java.util.UUID
import scala.jdk.CollectionConverters._

trait ReferenceIdUpgraderService extends Queries {
  def updateReferenceIds()
}

@Component
@Transactional("mainTransactionManager")
class DefaultReferenceIdUpgraderService (@Autowired @Qualifier("mainSchema") val schemaInfo: SchemaInfo,
                                         @Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                         @Autowired @Qualifier("mainTransactionManager") val transactionManager: PlatformTransactionManager,
                                         @Autowired @Qualifier("mainBatchExecutorRepository") val batchExecutorRepository: BatchExecutorRepository)
extends ReferenceIdUpgraderService {
  override def updateReferenceIds(): Unit = {
    val cis: List[CiPKType] = jdbcTemplate.query(sqlb"SELECT $idColumn from $tableName", new XlSingleColumnRowMapper(classOf[CiPKType])).asScala.toList
    val commands = cis.map(
      id => BatchCommand(sqlb"UPDATE $tableName SET $referenceIdColumn = ? WHERE $idColumn = ?", UUID.randomUUID().toString, id)
    )
    batchExecutorRepository.execute(commands)
  }
}
