package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.upgrade.service.ArchiveDateUpgraderService
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class Deployit2301SetArchiveDateColumnUpgrader (@Autowired val archiveDateUpgraderService: ArchiveDateUpgraderService)
                                                extends Upgrade with Logging {
  override def doUpgrade(): Boolean =
    Try {
      archiveDateUpgraderService.updateArchiveDateForArchivedTasks()
    } match {
      case Success(_) =>
        logger.debug("Archive Date column has been successfully updated.")
        true
      case Failure(exception: Exception) =>
        logger.error("Archive Date column cannot not be updated.", exception)
        false
    }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "23.1.0")
}
