package com.xebialabs.deployit.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging


trait ToggleableUpgrade extends Upgrade with Logging {

  val ignoreVersion = true

  override def shouldBeApplied(currentVersion: Version): Boolean =
    (!ignoreVersion && super.shouldBeApplied(currentVersion)) || toggleableSwitch(currentVersion)

  def toggleableSwitch(version: Version): Boolean

}
