package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.SchemaInfo
import com.xebialabs.deployit.core.upgrade.service.CiUpdateUpgraderService
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.transaction.PlatformTransactionManager
import org.springframework.transaction.annotation.Transactional

import scala.util.{Failure, Success, Try}

@Transactional("mainTransactionManager")
class Deployit1020SetCisWithNullParentId(@Autowired @Qualifier("mainSchema") val schemaInfo: SchemaInfo,
                                         @Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                         @Autowired @Qualifier("mainTransactionManager") val transactionManager: PlatformTransactionManager,
                                         @Autowired service: CiUpdateUpgraderService
                                            ) extends Upgrade with Logging {


  override def doUpgrade(): Boolean =
    Try {
      service.updateOrDeleteCisWithNullParentId()
    } match {
      case Success(_) =>
        logger.debug("Cis without parent_id successfully updated with parent_id or deleted.")
        true
      case Failure(exception: Exception) =>
        logger.error("Cis without parent_id cannot be updated or deleted.", exception)
        false
    }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.2.0")
}
