package com.xebialabs.deployit.core.upgrade

import java.io.{FileWriter, Writer}
import java.net.URI

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import grizzled.slf4j.Logging

import scala.jdk.CollectionConverters._
import scala.util._

class Deployit950HashAlgorithmUpgrader extends Upgrade with Logging{

  override def doUpgrade(): Boolean = Try {
    useSHA1()
  } match {
    case Success(_) =>
      logger.debug("Hashing algorithm configuration has been written successfully.")
      true
    case Failure(exception: Exception) =>
      logger.error("Hashing algorithm configuration cannot be written.", exception)
      false
  }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "9.5.0")

  private def useSHA1(): Unit = {
    val algo = "SHA-1"
    writeConfiguration(algo)
  }

  private def writeConfiguration(algo: String): Unit = {
    logger.info(s"Writing hashing algorithm configuration value [$algo] to the configuration file.")
    classLoader.getResources("xl-deploy.conf").asScala.toSeq.headOption.foreach { url =>
      val path = new URI(url.toString).getPath
      logger.debug(s"Configuration file path: $path")
      var fw: Writer = null
      try {
        fw = new FileWriter(path, true)
        fw.write(s"\nxl.algorithms.checksum = $algo\n")
      } finally {
        fw.close()
      }
    }
  }
}
