package com.xebialabs.deployit.permissions.upgrade

import ai.digital.configuration.central.deploy.permission.PermissionServiceProperties
import com.xebialabs.deployit.permissions.upgrade.service.PermissionServiceUpgrader
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.deployit.upgrade.ToggleableUpgrade
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class PermissionServiceAttachUpgrade(@Autowired properties: PermissionServiceProperties,
                                     @Autowired permissionServiceUpgrader: PermissionServiceUpgrader
) extends ToggleableUpgrade {

  override def toggleableSwitch(version: Version): Boolean = {
    if (properties.enabled && properties.forceCleanUpgrade) {
      val msg = """Permission service is enabled and xl.permission-service.force-clean-upgrade is set to true.
                  |   *** Permission service data will be cleaned-up and re-provisioned to permission service.
                  |   *** Consider setting xl.permission-service.force-clean-upgrade to *false* for next run to avoid PermissionServiceAttachUpgrade running again.
                  |""".stripMargin
      System.out.print(msg)
      logger.info(msg)
    }
    properties.enabled && (properties.forceCleanUpgrade || !permissionServiceUpgrader.isPermissionServiceAttached)
  }

  override def doUpgrade(): Boolean = {
    logger.info("Started migration of Role and Permission data to the Permission Service.")
    Try {
      if (properties.forceCleanUpgrade) {
        permissionServiceUpgrader.detachPermissionService()
      }
      permissionServiceUpgrader.attachPermissionService()
    } match {
      case Success(_) =>
        logger.info("Successfully migrated data to the Permission Service.")
        true
      case Failure(exception: Exception) =>
        logger.error(s"Failed migrated data to the Permission Service: ${exception.getMessage}", exception)
        logger.info("Cleaning up Permission Service attach")
        permissionServiceUpgrader.detachPermissionService()
        logger.info("Finished cleaning up Permission Service attach")
        false
    }
  }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.3.0")
}
