package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.upgrade.service.{ArchiveDirectoryRefUpgraderService, DirectoryRefUpgraderService}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class Deployit1020SetDirectoryIdAndReference(@Autowired val directoryRefUpgraderService: DirectoryRefUpgraderService,
                                             @Autowired val archiveDirectoryRefUpgraderService: ArchiveDirectoryRefUpgraderService
                                            ) extends Upgrade with Logging {

  override def doUpgrade(): Boolean =
    Try {
      directoryRefUpgraderService.updateDirectoryUUIDs()
      directoryRefUpgraderService.updateDirectoryRefs()
      val ciIdToDirReferencesMap = directoryRefUpgraderService.getCiIdDirectoryReferencesMap()
      archiveDirectoryRefUpgraderService.updateDirectoryRefsForArchivedTables(ciIdToDirReferencesMap)
    } match {
      case Success(_) =>
        logger.debug("Directory reference updates have been successfully applied.")
        true
      case Failure(exception: Exception) =>
        logger.error("Directory reference updates cannot be applied.", exception)
        false
    }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.2.0")
}
