package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.spring.transactional
import com.xebialabs.deployit.core.upgrade.service.LastVersionUpgraderService
import com.xebialabs.deployit.core.upgrade.service.SecurityUpgraderService
import com.xebialabs.deployit.server.api.upgrade.Upgrade
import com.xebialabs.deployit.server.api.upgrade.Version
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.transaction.PlatformTransactionManager

import scala.util.Failure
import scala.util.Success
import scala.util.Try

class Deployit1030LastVersionUpgrader(@Autowired val securityUpgraderService: SecurityUpgraderService,
                                      @Autowired val lastVersionUpgraderService: LastVersionUpgraderService,
                                      @Autowired @Qualifier("mainTransactionManager") val transactionManager: PlatformTransactionManager
                                     ) extends Upgrade with Logging {
  override def doUpgrade(): Boolean = doUpdateLastVersions()

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.3.0")

  private def doUpdateLastVersions(): Boolean = Try {
    transactional(transactionManager) {
      lastVersionUpgraderService.updateLastVersions()
    }

  } match {
    case Success(_) =>
      logger.debug("Last version updates for 10.3.0 have been successfully applied.")
      true
    case Failure(exception: Exception) =>
      logger.error("Last version updates 10.3.0 cannot be applied.", exception)
      false
  }
}
