package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.spring.transactional
import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.transaction.PlatformTransactionManager

import scala.util.Try

class ClearSpringSessionUpgrader
(
  @Autowired @Qualifier("mainSchema") val schemaInfo: SchemaInfo,
  @Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
  @Autowired @Qualifier("mainTransactionManager") transactionManager: PlatformTransactionManager
) extends Upgrade with Logging with Queries {

  override def doUpgrade(): Boolean = Try({
    transactional(transactionManager) {
      val springSessionTable = TableName("SPRING_SESSION", quoted = false)
      jdbcTemplate.update(sqlb"DELETE FROM $springSessionTable")
    }
  }).isSuccess

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.1.0")

  override def shouldBeApplied(currentVersion: Version): Boolean = true
}
