package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.{ColumnName, TableName}
import com.xebialabs.deployit.plugin.api.reflect.Type

package object service {

  object CISSchema {
    val tableName: TableName = TableName("XLD_CIS")

    val idColumn: ColumnName = ColumnName("ID")
    val ciTypeColumn: ColumnName = ColumnName("ci_type")
    val nameColumn: ColumnName = ColumnName("name")
    val pathColumn: ColumnName = ColumnName("path")
    val securedCiColumn: ColumnName = ColumnName("secured_ci")
    val parentIdColumn: ColumnName = ColumnName("parent_id")
    val directoryUUIDColumn: ColumnName = ColumnName("directory_uuid")
    val directoryRefColumn: ColumnName = ColumnName("directory_ref")
    val referenceIdColumn: ColumnName = ColumnName("reference_id")
  }

  object ArchivedDeploymentTasks {
    val archiveTasksTable: TableName = TableName("XLD_ARCHIVED_DEPLOYMENT_TASKS")

    val environment: ColumnName = ColumnName("environment")
    val environmentInternalId: ColumnName = ColumnName("environment_internal_id")
    val environmentSecuredCi: ColumnName = ColumnName("environment_secured_ci")
    val environmentDirRefColumn: ColumnName = ColumnName("environment_dir_ref")

    object Applications {
      val archiveApplicationTable: TableName = TableName("XLD_ARCHIVED_DT_APPLICATIONS")

      val application: ColumnName = ColumnName("application")
      val applicationInternalId: ColumnName = ColumnName("application_internal_id")
      val applicationSecuredCi: ColumnName = ColumnName("application_secured_ci")
      val applicationDirRefColumn: ColumnName = ColumnName("application_dir_ref")
    }

  }

  object ArchivedControlTasks {
    val archivedControlTasksTable: TableName = TableName("XLD_ARCHIVED_CONTROL_TASKS")

    val targetCi: ColumnName = ColumnName("target_ci")
    val targetInternalId: ColumnName = ColumnName("target_internal_id")
    val targetSecuredCi: ColumnName = ColumnName("target_secured_ci")
    val targetDirRefColumn: ColumnName = ColumnName("target_dir_ref")
  }

  object RolesSchema {

    object Roles {
      val tableName: TableName = TableName("XL_ROLES")
      val archivedTableName: TableName = TableName("XLD_ARCHIVE_ROLES")

      val ID: ColumnName = ColumnName("ID")
      val NAME: ColumnName = ColumnName("NAME")
      val CI_ID: ColumnName = ColumnName("CI_ID")
    }

    object RoleRoles {
      val tableName: TableName = TableName("XL_ROLE_ROLES")
      val archivedTableName: TableName = TableName("XLD_ARCHIVE_ROLE_ROLES")

      val ROLE_ID: ColumnName = ColumnName("ROLE_ID")
      val MEMBER_ROLE_ID: ColumnName = ColumnName("MEMBER_ROLE_ID")
    }

    object RolePrincipals {
      val tableName: TableName = TableName("XL_ROLE_PRINCIPALS")
      val archivedTableName: TableName = TableName("XLD_ARCHIVE_ROLE_PRINCIPALS")

      val ROLE_ID: ColumnName = ColumnName("ROLE_ID")
      val PRINCIPAL_NAME: ColumnName = ColumnName("PRINCIPAL_NAME")
    }

  }

  object PermissionsSchema {
    val tableName: TableName = TableName("XL_ROLE_PERMISSIONS")
    val archivedTableName: TableName = TableName("XLD_ARCHIVE_ROLE_PERMISSIONS")

    val ROLE_ID: ColumnName = ColumnName("ROLE_ID")
    val PERMISSION_NAME: ColumnName = ColumnName("PERMISSION_NAME")
    val CI_ID: ColumnName = ColumnName("CI_ID")
  }

}

final case class ConfigurationItemData(id: String, name: String, internalId: Integer, securedCi: Integer, ciType: Type)

final case class ConfigurationItemPropertiesData(ciId: Int, stringValue: String)

final case class ConfigurationItemDataVersion(id: String,
                                              name: String,
                                              internalId: Integer,
                                              securedCi: Integer,
                                              ciType: Type,
                                              parentId: Int,
                                              version: String
                                             )

final case class RoleEntry(id: String, name: String, ciId: Integer)

final case class RoleRole(roleId: String, memberRoleId: String)

final case class RolePrincipal(roleId: String, principalName: String)

final case class PermissionEntry(roleId: String, permissionName: String, ciId: Integer)
