package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.spring.transactional
import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo}
import com.xebialabs.deployit.core.upgrade.service.BatchUpgraderService
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Container, Deployable}
import com.xebialabs.deployit.repository.placeholders.ResolvedPlaceholderRepository
import com.xebialabs.deployit.repository.sql.{CiRepository, TypeNotFoundException}
import com.xebialabs.deployit.repository.{RepositoryService, SearchParameters}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.deployit.sql.base.schema.CI_PROPERTIES
import com.xebialabs.deployit.util.PasswordEncrypter
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.transaction.PlatformTransactionManager

import java.util
import java.util.{Map => JMap}
import scala.jdk.CollectionConverters._
import scala.util.Try

class Deployit954EncryptExposedFilePlaceholderValuesUpgrader(
                                                              @Autowired @Qualifier("mainSchema") val schemaInfo: SchemaInfo,
                                                              @Autowired ciRepository: CiRepository,
                                                              @Autowired resolvedPlaceholderRepository: ResolvedPlaceholderRepository,
                                                              @Autowired repositoryService: RepositoryService,
                                                              @Autowired @Qualifier("mainJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                              @Autowired @Qualifier("mainTransactionManager") transactionManager: PlatformTransactionManager,
                                                              @Autowired batchUpgraderService: BatchUpgraderService
                                                            ) extends Upgrade
  with Logging with Queries {

  override def upgradeVersion(): Version = Version.valueOf("deployit", "9.5.4-6")

  override def doUpgrade(): Boolean = {
    val passwordEncrypter = PasswordEncrypter.getInstance()
    val query = new SearchParameters().setType(Type.valueOf("udm.DerivedArtifact"))

    batchUpgraderService.getBatchCis(query, params => {
      ciRepository.listEntities(params).asScala.map { ci: ConfigurationItem =>
        val placeholders: JMap[String, String] = ci.getProperty("placeholders")
        logger.info(s"Found placeholders ${placeholders.keySet()}")

        val container: Option[Container] = Option(ci.getProperty("container"))
        val deployable: Option[Deployable] = Option(ci.getProperty("deployable"))

        if (container.isDefined && deployable.isDefined) {

          val deployablePath = deployable.fold("deployable_path"){_.getId}
          val versionPath = deployablePath.substring(0, deployablePath.length - deployablePath.split('/').last.length - 1)

          val newPlaceholders = new util.HashMap[String, String]()
          newPlaceholders.putAll(placeholders)
          val containerPath = container.fold("container_path")(_.getId)

          placeholders.asScala.foreach(placeholder => {
            val key = placeholder._1
            val value = placeholder._2
            if (resolvedPlaceholderRepository.isPlaceholderEncrypted(key, containerPath, versionPath)) {
              if (!passwordEncrypter.isEncrypted(value)) {
                val encrypted = passwordEncrypter.encrypt(value)
                if (encrypted.length <= 4000) {
                  logger.info(s"Placeholder $key in container $containerPath for application version $versionPath is going to be encrypted.")
                  newPlaceholders.put(key, encrypted)
                } else {
                  logger.info(s"Placeholder $key in container $containerPath for application version $versionPath is not going to be encrypted as value length is longer than 4000 characters")
                }
              }
            }
          })

          if (!newPlaceholders.equals(placeholders.asScala)) {
            ci.setProperty("placeholders", newPlaceholders)
            repositoryService.update(ci)
          }
        } else {
          logger.info(s"Skipping update of ${ci.getId} as container or deployable is null")
        }
      }
    })

    val result = Try({
      transactional(transactionManager) {
        val items = jdbcTemplate
          .queryForList(sqlb"select ${CI_PROPERTIES.ID}, ${CI_PROPERTIES.string_value} from ${CI_PROPERTIES.tableName} where ${CI_PROPERTIES.string_value} like 'u{{aes%'")

        items.asScala.foreach(map => {
          val id = map.get(CI_PROPERTIES.ID.name)
          val sv = map.get(CI_PROPERTIES.string_value.name).asInstanceOf[String]

          val newSV = sv.replaceAll("u\\{\\{aes", "e{{aes")
          jdbcTemplate.update(sqlb"update ${CI_PROPERTIES.tableName} set ${CI_PROPERTIES.string_value} = '$newSV' where ${CI_PROPERTIES.ID} = $id")
        })
      }
    })
    result.failed.foreach(error("Unable to complete Deployit9545ChangeEncryptionLetterUpgrader.", _))
    result.isSuccess
  }
}
