package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.{ColumnName, TableName}
import com.xebialabs.deployit.plugin.api.reflect.Type

package object service {

  object CISSchema {
    val tableName = TableName("XLD_CIS")

    val idColumn = ColumnName("ID")
    val ciTypeColumn = ColumnName("ci_type")
    val nameColumn = ColumnName("name")
    val pathColumn = ColumnName("path")
    val securedCiColumn = ColumnName("secured_ci")
    val parentIdColumn = ColumnName("parent_id")
    val directoryUUIDColumn = ColumnName("directory_uuid")
    val directoryRefColumn = ColumnName("directory_ref")
  }

  object ArchivedDeploymentTasks {
    val archiveTasksTable = TableName("XLD_ARCHIVED_DEPLOYMENT_TASKS")

    val environment = ColumnName("environment")
    val environmentInternalId = ColumnName("environment_internal_id")
    val environmentSecuredCi = ColumnName("environment_secured_ci")
    val environmentDirRefColumn = ColumnName("environment_dir_ref")

    object Applications {
      val archiveApplicationTable = TableName("XLD_ARCHIVED_DT_APPLICATIONS")

      val application = ColumnName("application")
      val applicationInternalId = ColumnName("application_internal_id")
      val applicationSecuredCi = ColumnName("application_secured_ci")
      val applicationDirRefColumn = ColumnName("application_dir_ref")
    }

  }

  object ArchivedControlTasks {
    val archivedControlTasksTable = TableName("XLD_ARCHIVED_CONTROL_TASKS")

    val targetCi = ColumnName("target_ci")
    val targetInternalId = ColumnName("target_internal_id")
    val targetSecuredCi = ColumnName("target_secured_ci")
    val targetDirRefColumn = ColumnName("target_dir_ref")
  }

  object RolesSchema {

    object Roles {
      val tableName = TableName("XL_ROLES")
      val archivedTableName = TableName("XLD_ARCHIVE_ROLES")

      val ID = ColumnName("ID")
      val NAME = ColumnName("NAME")
      val CI_ID = ColumnName("CI_ID")
    }

    object RoleRoles {
      val tableName = TableName("XL_ROLE_ROLES")
      val archivedTableName = TableName("XLD_ARCHIVE_ROLE_ROLES")

      val ROLE_ID = ColumnName("ROLE_ID")
      val MEMBER_ROLE_ID = ColumnName("MEMBER_ROLE_ID")
    }

    object RolePrincipals {
      val tableName = TableName("XL_ROLE_PRINCIPALS")
      val archivedTableName = TableName("XLD_ARCHIVE_ROLE_PRINCIPALS")

      val ROLE_ID = ColumnName("ROLE_ID")
      val PRINCIPAL_NAME = ColumnName("PRINCIPAL_NAME")
    }

  }

  object PermissionsSchema {
    val tableName = TableName("XL_ROLE_PERMISSIONS")
    val archivedTableName = TableName("XLD_ARCHIVE_ROLE_PERMISSIONS")

    val ROLE_ID = ColumnName("ROLE_ID")
    val PERMISSION_NAME = ColumnName("PERMISSION_NAME")
    val CI_ID = ColumnName("CI_ID")
  }

}

final case class ConfigurationItemData(id: String, name: String, internalId: Integer, securedCi: Integer, ciType: Type)

final case class ConfigurationItemPropertiesData(ciId: Int, stringValue: String)

final case class ConfigurationItemDataVersion(id: String,
                                              name: String,
                                              internalId: Integer,
                                              securedCi: Integer,
                                              ciType: Type,
                                              parentId: Int,
                                              version: String
                                             )

final case class RoleEntry(id: String, name: String, ciId: Integer)

final case class RoleRole(roleId: String, memberRoleId: String)

final case class RolePrincipal(roleId: String, principalName: String)

final case class PermissionEntry(roleId: String, permissionName: String, ciId: Integer)
