package com.xebialabs.deployit.core.upgrade

import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory
import com.xebialabs.deployit.core.api.dto.settings.ConfigurationDto
import com.xebialabs.deployit.repository.ConfigurationRepository
import com.xebialabs.deployit.server.api.upgrade.Upgrade
import com.xebialabs.deployit.server.api.upgrade.Version
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import java.io.File
import scala.util.Failure
import scala.util.Success
import scala.util.Try

class Deployit1020MoveAuthMessageToDatabase(@Autowired configurationRepository: ConfigurationRepository
                                            ) extends Upgrade with Logging {

  private val AUTH_HTML_MESSAGE: String = "xl.gui.login.auth-html-message"
  private val CONFIGURATION_TITLE: String = "Login Screen Message"
  private val CONFIGURATION_KEY: String = "login_screen_message"
  private val CONFIG_FILE_PATH: String = "conf/xl-deploy.conf"

  val configFile: File = new File(CONFIG_FILE_PATH)
  var config: Config = _
  var configuredAuthMessage: String = _

  override def doUpgrade(): Boolean =
    Try {
      if (configFile.exists()) {
        config = ConfigFactory.parseFile(configFile)

        if (config.hasPath(AUTH_HTML_MESSAGE)) {
          configuredAuthMessage = config.getString(AUTH_HTML_MESSAGE)

          if (configuredAuthMessage != null && !configuredAuthMessage.isBlank) {
            configurationRepository.saveOrUpdate(ConfigurationDto(CONFIGURATION_TITLE, CONFIGURATION_KEY,
              configuredAuthMessage))
          }
        }
      }
    } match {
      case Success(_) =>
        if (!configFile.exists())
          logger.debug(s"${CONFIG_FILE_PATH} file is not found. Not able to move ${AUTH_HTML_MESSAGE} " +
            s"to database. Hope that is fine.")
        else if (config.hasPath(AUTH_HTML_MESSAGE))
          logger.debug(s"Successfully moved ${AUTH_HTML_MESSAGE} configuration setting to database.")
        else
          logger.debug(s"${AUTH_HTML_MESSAGE} is not configured. Safe to ignore.")
        true
      case Failure(exception: Exception) =>
        logger.error(s"Failed to move ${AUTH_HTML_MESSAGE} configuration setting to database", exception)
        false
    }


  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.2.0")
}
