/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade.service;

import com.xebialabs.deployit.core.config.ClientProperties;
import com.xebialabs.deployit.core.upgrade.service.BatchUpgraderService;
import com.xebialabs.deployit.engine.spi.artifact.resolution.CannotLocateArtifactException;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.TypeNotFoundException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@Component
@ScalaSignature(bytes="\u0006\u0005)4Aa\u0002\u0005\u0001+!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u0003A\u0001\u0011\u0005\u0011\tC\u0005F\u0001\u0001\u0007\t\u0019!C\u0001\r\"IQ\n\u0001a\u0001\u0002\u0004%\tA\u0014\u0005\n)\u0002\u0001\r\u0011!Q!\n\u001dCQA\u0016\u0001\u0005B]\u00131\u0004R3gCVdGOQ1uG\",\u0006o\u001a:bI\u0016\u00148+\u001a:wS\u000e,'BA\u0005\u000b\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0003\u0007\u0002\u000fU\u0004xM]1eK*\u0011QBD\u0001\u0005G>\u0014XM\u0003\u0002\u0010!\u0005AA-\u001a9m_fLGO\u0003\u0002\u0012%\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0006\u000f!!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u0011%\u0011q\u0004\u0003\u0002\u0015\u0005\u0006$8\r[+qOJ\fG-\u001a:TKJ4\u0018nY3\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!B:mMRR'\"A\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\n\u0012\u0003\u000f1{wmZ5oO\u0006a1-\u001b*fa>\u001c\u0018\u000e^8ssB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0004gFd'B\u0001\u0018\u000f\u0003)\u0011X\r]8tSR|'/_\u0005\u0003a-\u0012AbQ5SKB|7/\u001b;pefD#!\u0001\u001a\u0011\u0005MrT\"\u0001\u001b\u000b\u0005U2\u0014AC1o]>$\u0018\r^5p]*\u0011q\u0007O\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI$(A\u0003cK\u0006t7O\u0003\u0002<y\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001>\u0003\ry'oZ\u0005\u0003\u007fQ\u0012\u0011\"Q;u_^L'/\u001a3\u0002\rqJg.\u001b;?)\t\u00115\t\u0005\u0002\u001e\u0001!)\u0001F\u0001a\u0001S!\u00121IM\u0001\u0014G2LWM\u001c;D_:4\u0017nZ;sCRLwN\\\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nD\u0001\u0007G>tg-[4\n\u00051K%\u0001E\"mS\u0016tG\u000f\u0015:pa\u0016\u0014H/[3t\u0003]\u0019G.[3oi\u000e{gNZ5hkJ\fG/[8o?\u0012*\u0017\u000f\u0006\u0002P%B\u0011q\u0003U\u0005\u0003#b\u0011A!\u00168ji\"91\u000bBA\u0001\u0002\u00049\u0015a\u0001=%c\u0005!2\r\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002B#!\u0002\u001a\u0002\u0017\u001d,GOQ1uG\"\u001c\u0015n\u001d\u000b\u0004\u001fbs\u0006\"B-\u0007\u0001\u0004Q\u0016!B9vKJL\bCA.]\u001b\u0005i\u0013BA/.\u0005A\u0019V-\u0019:dQB\u000b'/Y7fi\u0016\u00148\u000fC\u0003`\r\u0001\u0007\u0001-A\u0007cCR\u001c\u0007nQ1mY\n\f7m\u001b\t\u0005/\u0005Tv*\u0003\u0002c1\tIa)\u001e8di&|g.\r\u0015\u0003\u0001\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u001e\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002jM\nI1i\\7q_:,g\u000e\u001e")
public class DefaultBatchUpgraderService
implements BatchUpgraderService,
Logging {
    @Autowired
    private final CiRepository ciRepository;
    @Autowired
    private ClientProperties clientConfiguration;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultBatchUpgraderService defaultBatchUpgraderService = this;
        synchronized (defaultBatchUpgraderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    @Override
    public void getBatchCis(SearchParameters query, Function1<SearchParameters, BoxedUnit> batchCallback) {
        int batchSize = this.clientConfiguration().upgradeBatchSize();
        Integer count = this.ciRepository.count(query);
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(47).append("Running batch migration on ").append(count).append(" CIs in batches of ").append(batchSize).append(".").toString());
        IntRef pagesIndexed = IntRef.create((int)0);
        int totalPages = (Predef$.MODULE$.Integer2int(count) + batchSize - 1) / batchSize;
        while (pagesIndexed.elem < totalPages) {
            SearchParameters params = query.setPage((long)pagesIndexed.elem).setResultsPerPage((long)batchSize);
            try {
                Object object;
                try {
                    object = batchCallback.apply((Object)params);
                }
                catch (TypeNotFoundException e) {
                    this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e.getCause());
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(36).append("Skipping page ").append(pagesIndexed$1.elem).append(" due to a missed type.").toString());
                    object = BoxedUnit.UNIT;
                }
                catch (CannotLocateArtifactException e) {
                    this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e.getCause());
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(38).append("Skipping page ").append(pagesIndexed$1.elem).append(" due to missed artifact.").toString());
                    object = BoxedUnit.UNIT;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
            finally {
                ++pagesIndexed.elem;
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(27).append("Completed batch ").append(pagesIndexed$1.elem).append(" / total: ").append(totalPages).append(".").toString());
            }
        }
    }

    public DefaultBatchUpgraderService(@Autowired CiRepository ciRepository) {
        this.ciRepository = ciRepository;
        Logging.$init$((Logging)this);
    }
}

