package com.xebialabs.deployit.repository.sql

import com.xebialabs.deployit.engine.spi.event.{CiCopiedEvent, CisCreatedEvent, CisDeletedEvent, DeployitEventListener}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe

import scala.collection.mutable
import scala.jdk.CollectionConverters._

@DeployitEventListener
class LicenseCiCountEventListener extends Logging {

  @Subscribe
  def onCreate(event: CisCreatedEvent): Unit = {
    val cis = event.getCis.asScala
    logger.trace(s"Clearing license count for created $cis.")
    removeAllCis(cis, "CisCreatedEvent")
  }

  @Subscribe
  def onDelete(event: CisDeletedEvent): Unit = {
    val cis = event.getCis.asScala
    logger.trace(s"Clearing license count for deleted $cis.")
    removeAllCis(cis, "CisDeletedEvent")
  }

  @Subscribe
  def onCopy(event: CiCopiedEvent): Unit = {
    val cis = event.getCi
    logger.trace(s"Clearing license count for copied $cis.")
    LicenseCacheDataServiceHolder
      .getLicenseCacheDataService.remove(cis.getType.toString)
  }

  def removeAllCis(cis: mutable.Buffer[ConfigurationItem], eventName: String): Unit = {
    LicenseCacheDataServiceHolder
      .getLicenseCacheDataService
      .removeAll(cis.map(_.getType.toString).toSet.asJava)
    logger.trace(s"$eventName: entries in ${LicenseCacheDataServiceHolder.getLicenseCacheDataService.cacheName}: ${LicenseCacheDataServiceHolder.getLicenseCacheDataService.getAll}")
  }
}
