package com.xebialabs.deployit.repository.sql

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.SearchParameters
import com.xebialabs.license.LicenseCiCounter.LicensedCiUse
import grizzled.slf4j.Logging

trait SqlLicenseUsageProvider {
  def getCiCount(ciType: Type): Int
  def licensedCisInUse(restrictedTypes: Map[Type, Int]): Array[LicensedCiUse]
}

class CiSqlLicenseUsageProvider(ciRepository: CiRepository, licenseCacheDataService: LicenseCacheDataService)
  extends SqlLicenseUsageProvider with Logging {
  override def getCiCount(ciType: Type): Int = {
    licenseCacheDataService.get(ciType.toString).getOrElse[Integer]({
      val criteria = new SearchParameters()
      criteria.setType(ciType)
      val count = ciRepository.count(criteria)
      licenseCacheDataService.put(ciType.toString, count)
      count
    })
  }

  override def licensedCisInUse(restrictedTypes: Map[Type, Int]): Array[LicensedCiUse] = {
    restrictedTypes.map { case (ciType: Type, maxAllowed: Int) =>
      LicensedCiUse(`type` = ciType, allowedAmount = maxAllowed, actualAmount = getCiCount(ciType))
    }.toArray
  }
}
