package com.xebialabs.deployit.repository.sql

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.license.service.LicenseCiCounterFactory
import com.xebialabs.license.{LicenseCiCounter, License, LicenseProperty}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class SqlLicenseCiCounterFactory(ciRepository: CiRepository) extends LicenseCiCounterFactory {

  override def create(license: License): LicenseCiCounter = {
    val restrictions = license.getMapValue(LicenseProperty.MAX_NUMBER_OF_CIS).asScala.map {
      case (typeString, n) => (Type.valueOf(typeString), n.toInt)
    }
    createSqlCounter(restrictions.toMap)
  }

  private def createSqlCounter(map: Map[Type, Int]): LicenseCiCounter = {
    val sqlCountProvider = new CiSqlLicenseUsageProvider(ciRepository)
    new SqlLicenseCiCounter(map, sqlCountProvider)
  }
}

