package com.xebialabs.deployit.sql.base.schema

import com.xebialabs.deployit.core.sql.{ColumnName, TableName}

object ActiveTaskSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS")

  val task_id: ColumnName = ColumnName("task_id")
  val description: ColumnName = ColumnName("description")
  val task_owner: ColumnName = ColumnName("task_owner")
  val worker_id: ColumnName = ColumnName("worker_id")
  val state: ColumnName = ColumnName("state")
  val startDate: ColumnName = ColumnName("start_date")
  val completionDate: ColumnName = ColumnName("completion_date")
}

object ActiveTaskMetadataSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS_METADATA")

  val task_id: ColumnName = ColumnName("task_id")
  val metadata_key: ColumnName = ColumnName("metadata_key")
  val metadata_value: ColumnName = ColumnName("metadata_value")
}

object ActiveTaskMetadataKey {
  val APPLICATION_INTERNAL_ID: String = "application_internal_id"
  val ENVIRONMENT_INTERNAL_ID: String = "environment_internal_id"
  val CONTROL_TASK_TARGET_INTERNAL_CI: String = "controlTaskTargetInternalCI"
}

object ActiveTaskPathStatusSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASK_PATH_STATUS")

  val ID: ColumnName = ColumnName("ID")
  val taskId: ColumnName = ColumnName("task_id")
  val path: ColumnName = ColumnName("path")
  val status: ColumnName = ColumnName("status")
  val updateTime: ColumnName = ColumnName("update_time")
}

object ActiveTaskStepLogSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASK_STEP_LOG")

  val taskId: ColumnName = ColumnName("task_id")
  val stepPath: ColumnName = ColumnName("step_path")
  val log: ColumnName = ColumnName("log")
  val lineNumber: ColumnName = ColumnName("line_number")
  val logLevel: ColumnName = ColumnName("log_level")
  val attempt: ColumnName = ColumnName("attempt")
  val updateTime: ColumnName = ColumnName("update_time")
}

object ActiveTaskDataSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS_DATA")

  val task_id: ColumnName = ColumnName("task_id")
  val serialization_type: ColumnName = ColumnName("serialization_type")
  val specification: ColumnName = ColumnName("task_specification")
}
