/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public Timestamp toTimestamp(DateTime dateTime) {
        return new Timestamp(dateTime.getMillis());
    }

    public Calendar toCalendar(Timestamp timestamp) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(timestamp.getTime());
        return calendar;
    }

    public Calendar toCalendar(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.withZone(DateTimeZone.UTC).toGregorianCalendar();
    }

    public DateTime toDateTime(Timestamp timestamp) {
        return new DateTime(timestamp.getTime(), DateTimeZone.UTC);
    }

    public DateTime toDateTime(LocalDateTime dateTime) {
        return new DateTime(dateTime.atOffset(ZoneOffset.UTC).toInstant().toEpochMilli(), DateTimeZone.UTC);
    }

    public DateTime mapDateTime(Object date) {
        Object object = date;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return this.toDateTime(timestamp);
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return this.toDateTime(localDateTime);
        }
        throw new IllegalArgumentException("Cannot map date of " + date + " to DateTime");
    }

    public Calendar UTC_CALENDAR() {
        return UTC_CALENDAR;
    }

    public void setTimestamp(PreparedStatement preparedStatement, int index, DateTime dateTime) {
        if (dateTime == null) {
            preparedStatement.setNull(index, 93);
            return;
        }
        preparedStatement.setTimestamp(index, this.toTimestamp(dateTime), this.toCalendar(dateTime));
    }

    public Integer asInteger(Object any) {
        Object object = any;
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return Predef$.MODULE$.int2Integer(number.intValue());
        }
        throw new IllegalArgumentException("Cannot convert " + any + " to Integer.");
    }

    public Long asLong(Object any) {
        Object object = any;
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return Predef$.MODULE$.long2Long(number.longValue());
        }
        throw new IllegalArgumentException("Cannot convert " + any + " to Long.");
    }

    public String orderByClause(Seq<OrderBy> orderBy, Option<String> tableAlias, SchemaInfo schemaInfo) {
        return this.mkString((Iterable<Object>)((Iterable)orderBy.map((Function1 & Serializable)x$1 -> x$1.build(tableAlias, schemaInfo))), "", " order by ", ", ", "");
    }

    public String mkString(Iterable<Object> iterable, String empty, String start, String sep, String end) {
        if (iterable.isEmpty()) {
            return empty;
        }
        return iterable.mkString(start, sep, end);
    }

    private package$() {
    }
}

