package com.xebialabs.deployit.core.sql

sealed trait SqlFragment {
  def build(implicit schemaInfo: SchemaInfo): String
}

class SelectFragment(private val columns: Seq[String], private val distinct: Boolean = false, private val count: Boolean = false) extends SqlFragment {
  override def build(implicit schemaInfo: SchemaInfo): String = {
    val start: String = (if (count) "count(" else "") + (if (distinct) "distinct " else "")
    mkString(columns, "*", start, ", ", if (count) ")" else "")
  }

  def combine(other: SelectFragment) = new SelectFragment(this.columns ++ other.columns, this.distinct || other.distinct, this.count || other.count)
}

class WhereFragment(private val conditions: Seq[String], empty: String = "", start: String = " where ", sep: String = " and ", end: String = "") extends SqlFragment {
  override def build(implicit schemaInfo: SchemaInfo): String =
    mkString(conditions, empty, start, sep, end)

  def combine(other: WhereFragment) = new WhereFragment(this.conditions ++ other.conditions)
}

class GroupByFragment(private val groups: Seq[String]) extends SqlFragment {
  override def build(implicit schemaInfo: SchemaInfo): String = mkString(groups, "", " group by ", ", ", "")

  def combine(other: GroupByFragment): GroupByFragment = new GroupByFragment(this.groups ++ other.groups)
}

class OrderByFragment(private val orders: Seq[String]) extends SqlFragment {
  override def build(implicit schemaInfo: SchemaInfo): String = mkString(orders, "", " order by ", ", ", "")

  def combine(other: OrderByFragment) = new OrderByFragment(this.orders ++ other.orders)
}
