package com.xebialabs.deployit.sql.base.schema

import com.xebialabs.deployit.core.sql.ColumnName
import com.xebialabs.deployit.core.sql.TableName

object ActiveTaskSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS")

  val task_id: ColumnName = ColumnName("task_id")
  val description: ColumnName = ColumnName("description")
  val task_owner: ColumnName = ColumnName("task_owner")
  val worker_id: ColumnName = ColumnName("worker_id")
}

object ActiveTaskMetadataSchema {

  val tableName: TableName = TableName("XLD_ACTIVE_TASKS_METADATA")

  val task_id: ColumnName = ColumnName("task_id")
  val metadata_key: ColumnName = ColumnName("metadata_key")
  val metadata_value: ColumnName = ColumnName("metadata_value")
}

object ActiveTaskMetadataKey {
  val APPLICATION_INTERNAL_ID: String = "application_internal_id"
  val ENVIRONMENT_INTERNAL_ID: String = "environment_internal_id"
  val CONTROL_TASK_TARGET_INTERNAL_CI: String = "controlTaskTargetInternalCI"
}

object TaskPathStatusSchema {

  val tableName: TableName = TableName("XLD_TASK_PATH_STATUS")

  val taskId: ColumnName = ColumnName("task_id")
  val path: ColumnName = ColumnName("path")
  val status: ColumnName = ColumnName("status")
  val updateTime: ColumnName = ColumnName("update_time")
}
