package ai.digital.deploy.settings

case class GeneralSettings(headerColor: String,
                           instanceName: String,
                           loginScreenMessage: String,
                           logoFile: String,
                           patEnableForSSO: Boolean,
                           patExpirationDuration: String,
                           patEmailNotificationEnabled: Boolean = false,
                           patEmailNotificationTriggerPeriod: String = "",
                           patEmailNotificationSMTPServerCiRef: String = "",
                           patEmailNotificationSMTPServerCiName: String = "") {

  object GeneralSettings {

    @scala.annotation.tailrec
    def apply(): GeneralSettings = GeneralSettings()

    def apply(headerColor: String, instanceName: String, loginScreenMessage: String, logoFile: String,
              patEnableForSSO: Boolean, patExpirationDuration: String, patEmailNotificationEnabled: Boolean, patEmailNotificationTriggerPeriod: String, patEmailNotificationSMTPServerCiRef: String,
              patEmailNotificationSMTPServerCiName: String) =
      new GeneralSettings(headerColor, instanceName, loginScreenMessage, logoFile,
        patEnableForSSO, patExpirationDuration, patEmailNotificationEnabled, patEmailNotificationTriggerPeriod, patEmailNotificationSMTPServerCiRef, patEmailNotificationSMTPServerCiName)
  }
}
