package ai.digital.deploy.scheduler.jobs

import ai.digital.deploy.pendo.metrics.XldPendoMetricsService
import ai.digital.deploy.scheduler.{Impersonation, ScheduledJob, Trigger}
import com.xebialabs.deployit.security.PermissionEnforcer.ROLE_ADMIN
import org.springframework.beans.factory.annotation.Autowired

class PendoMetricsCollectionJob(jobId: String, jobTrigger: Trigger) extends ScheduledJob with Impersonation {

  @Autowired
  var xldPendoMetricsService: XldPendoMetricsService = _

  override def execute: Unit =  {
    impersonateAs("admin", roles = List(ROLE_ADMIN)) {
      xldPendoMetricsService.processMetrics()
    }
  }

  override def id: String = jobId

  override def trigger: Trigger = jobTrigger
}

