package ai.digital.deploy.scheduler

import ai.digital.configuration.central.deploy.ServerSideProperties
import ai.digital.deploy.scheduler.jobs.PendoMetricsCollectionJob
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, ComponentScan, Configuration}
import grizzled.slf4j.Logging

@Configuration
@ComponentScan(Array("ai.digital.deploy.pendo"))
class ScheduledJobsConfiguration extends Logging {

  @Autowired
  var serverSideProperties: ServerSideProperties = _

  @Bean
  def pendoCronTrigger(): Trigger = CronTrigger(serverSideProperties.analytics.pendoMetricsCron)

  @Bean
  def pendoMetricsCollectionJob(): PendoMetricsCollectionJob = new PendoMetricsCollectionJob("pendoMetrics",
    pendoCronTrigger)

  def getScheduledJobs(): List[ScheduledJob] = {
    List(pendoMetricsCollectionJob)
  }

}
