package ai.digital.deploy.scheduler

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken
import org.springframework.security.core.authority.SimpleGrantedAuthority
import org.springframework.security.core.context.SecurityContextHolder

import scala.jdk.CollectionConverters._

trait Impersonation {
  def impersonateAs(username: String, password: String = "", roles: List[String] = List())(func: => Unit): Unit = {
    val context = SecurityContextHolder.getContext
    val origAuthentication = context.getAuthentication
    try {
      context.setAuthentication(new UsernamePasswordAuthenticationToken(username, password, roles.map(new SimpleGrantedAuthority(_)).asJava))
      func
    } finally {
      context.setAuthentication(origAuthentication)
    }
  }
}
