package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

@StepMetadata(name="reference-check-step")
public class ReferenceCheckStep implements Step {

    @StepParameter(description = "Deployed")
    private Deployed deployed;

    @StepParameter(description = "Deployed Application")
    private DeployedApplication deployedApplication;

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public String getDescription() {
        return "Reference check step";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("Reference check step integration test started");

        checkCiReference(this.deployed, deployedApplication.getDeployeds().iterator().next(), ctx);
        checkCiReference(this.deployed.getDeployable(), deployedApplication.getVersion().getDeployables().iterator().next(), ctx);
        checkCiReference(this.deployed.getContainer(), deployedApplication.getEnvironment().getMembers().iterator().next(), ctx);

        return StepExitCode.SUCCESS;
    }

    private void checkCiReference(ConfigurationItem first, ConfigurationItem second, ExecutionContext ctx) {
        boolean firstEqual = first.equals(second);
        boolean secondEqual = first == second;
        ctx.logOutput(first.getId() + " equals " + second.getId() + " | " + String.valueOf(firstEqual));
        ctx.logOutput(first.getId() + " == " + second.getId() + " | " + String.valueOf(secondEqual));
        if(!(firstEqual && secondEqual)) {
            throw new RuntimeException("reference and equality check failed for CI " + first.getId());
        }

    }

}
