package com.xebialabs.deployit.plugin.test.yak.orchestrator;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;

import java.util.ArrayList;
import java.util.List;


@Orchestrator.Metadata(name = "deep-nesting")
public class DeepNestingOrchestrator implements Orchestrator {

    @Override
    public Orchestration orchestrate(final DeltaSpecification specification) {

        List<Orchestration> parallels = new ArrayList<>();

        for(int i = 0; i < specification.getDeltas().size() / 2; i++) {
            parallels.add(
                    Orchestrations.parallel(
                            "p" + i,
                            Orchestrations.interleaved("i" + i + "0", specification.getDeltas().get(i * 2)),
                            Orchestrations.interleaved("i" + i + "1", specification.getDeltas().get(i * 2 + 1)))
            );
        }

        if (parallels.size() * 2 < specification.getDeltas().size()) {
            parallels.add(Orchestrations.interleaved("i" + specification.getDeltas().size(), specification.getDeltas().get(specification.getDeltas().size() - 1)));
        }


        List<Orchestration> serials = new ArrayList<>();
        serials.add(Orchestrations.serial("s", parallels.subList(0, parallels.size() / 2)));
        if (parallels.size() > 1) {
            serials.add(Orchestrations.serial("s2", parallels.subList(parallels.size() / 2 + 1, parallels.size())));
        }

        return Orchestrations.parallel("ppp", serials);
    }
}
