package com.xebialabs.deployit.plugin.test.v3;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

@SuppressWarnings("serial")
public class DeployDummyStep implements Step {

    private DummyDeployed deployed;
    private int order;

    public DeployDummyStep(int order, DummyDeployed deployed) {
        this.order = order;
        this.deployed = deployed;
    }

    public String getDescription() {
        return "Deploy " + deployed;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Deploying " + deployed.getName());
        for (String key : deployed.getProps().keySet()) {
            ctx.logOutput("  " + key + ": " + deployed.getProps().get(key));
        }

        return StepExitCode.SUCCESS;
    }

    @Override
    public int getOrder() {
        return order;
    }
}
