package com.xebialabs.deployit.plugin.test.v3;

import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.SearchParameters;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;

public class DummyJeeServerOnDummyHostDeployedDatasource extends BaseDeployed<DummyDatasource, DummyJeeServerOnDummyHost> {

    @Property(required = false, candidateValuesFilter = "jdbcProviderOnSameJeeServer")
    private DummyJeeServerOnDummyHostDeployedJdbcProvider filteredJdbc;

    @Property(required = false)
    private DummyJeeServerOnDummyHostDeployedJdbcProvider unfilteredJdbc;

    @Property(required = false, candidateValuesFilter = "jdbcProviderOnSameJeeServer")
    private Set<DummyJeeServerOnDummyHostDeployedJdbcProvider> filteredSetOfJdbcs;

    @Property(required = false)
    private Set<DummyJeeServerOnDummyHostDeployedJdbcProvider> unfilteredSetOfJdbcs;

    @Property(required = false, candidateValuesFilter = "jdbcProviderOnSameJeeServer")
    private List<DummyJeeServerOnDummyHostDeployedJdbcProvider> filteredListOfJdbcs;

    @Property(required = false)
    private List<DummyJeeServerOnDummyHostDeployedJdbcProvider> unfilteredListOfJdbcs;

    @CandidateValuesFilter(name = "jdbcProviderOnSameJeeServer")
    public static SearchParameters findJdbcProviders(ConfigurationItem context, PropertyDescriptor property) {
        SearchParameters params = new SearchParameters();
        params.setType(property.getReferencedType());
        if (context.getType().instanceOf(Type.valueOf(DummyJeeServerOnDummyHostDeployedDatasource.class))) {
            params.setAncestor(((DummyJeeServerOnDummyHostDeployedDatasource) context).getContainer().getId());
        }
        return params;
    }

}
