package com.xebialabs.deployit.overthere.test;

import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.BaseOverthereFile;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class DummyOverthereFile extends BaseOverthereFile implements OverthereFile {

    private OverthereConnection connection;

    public DummyOverthereFile(OverthereConnection connection) {
        this.connection = connection;
    }


    @Override
    public String getPath() {
        return "path";
    }

    @Override
    public String getName() {
        return "name";
    }

    @Override
    public OverthereFile getParentFile() {
        return new DummyOverthereFile(connection);
    }

    @Override
    public OverthereFile getFile(String child) {
        return new DummyOverthereFile(connection);
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0;
    }

    @Override
    public long length() {
        return 0;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(new byte[1]);
    }

    @Override
    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream();
    }

    @Override
    public void setExecutable(boolean executable) {

    }

    @Override
    public void delete() {

    }

    @Override
    public void deleteRecursively() {

    }

    @Override
    public List<OverthereFile> listFiles() {
        return new ArrayList<>();
    }

    @Override
    public void mkdir() {

    }

    @Override
    public void mkdirs() {

    }

    @Override
    public void renameTo(OverthereFile dest) {

    }

    @Override
    public String toString() {
        return "DummyOverthereFile";
    }
}
