package com.xebialabs.deployit.plugin.test.v3;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
public class DummyDeployed extends BaseDeployed<DummyDeployable, DummyJeeServer> {

    @SuppressWarnings("unused")
    private String aStringProperty;

    @Property(required = false)
    private Map<String, String> props = newHashMap();

    @Property(required = false)
    private List<String> listProps = newArrayList();

    @Create @Destroy
    public void create(DeploymentPlanningContext result) {
        result.addStep(new DeployDummyStep(40, this));
    }

    public Map<String, String> getProps() {
        return props;
    }

    public List<String> getListProps() {
        return listProps;
    }
}
