package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

import java.util.concurrent.atomic.AtomicBoolean;

@SuppressWarnings("serial")
public class FirstTimePauseStep implements Step {
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private int order;

    public FirstTimePauseStep(int order) {

        this.order = order;
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public String getDescription() {
        return "Pause";
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        if (!paused.getAndSet(true)) {
            return StepExitCode.PAUSE;
        }
        return StepExitCode.SUCCESS;
    }
}
