package com.xebialabs.deployit.plugin.test.v3;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.deployit.plugin.api.flow.StepExitCode.SUCCESS;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE, inspectable = true)
public class DummyHost extends DummyContainer {

    @Property
    @InspectionProperty(required = true)
    private String address;

    @Property
    private String os;

    @Property
    private String accessMethod;

    @Property
    @InspectionProperty(required = true)
    private String username;

    @Property
    @InspectionProperty(required = true)
    private String password;

    @Property(description = "Servers in the node", asContainment = true, required = false)
    private Set<DummyContainer> servers = newHashSet();

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getAccessMethod() {
        return accessMethod;
    }

    public void setAccessMethod(String accessMethod) {
        this.accessMethod = accessMethod;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Inspect
    public void inspectContainer(InspectionContext context) {
        context.addStep(new DummyInspectionStep1(this));
        context.addStep(new DummyInspectionStep2(this));
    }

    class DummyInspectionStep1 implements Step {

        DummyHost dummyHost;

        public DummyInspectionStep1(DummyHost dummyHost) {
            this.dummyHost = dummyHost;
        }

        @Override
        public String getDescription() {
            return "Inspecting DummyHost on " + getId();
        }

        @Override
        public StepExitCode execute(ExecutionContext context) throws Exception {

            setOs("hoefnix");
            setAccessMethod("ssh");

            DummyJeeCluster server = new DummyJeeCluster();
            server.setId(getId() + "/DummyJeeCluster1");
            server.setHostName(address);
            server.setHost(this.dummyHost);
            servers.add(server);

            DummyJeeCluster server2 = new DummyJeeCluster();
            server2.setId(getId() + "/DummyJeeCluster2");
            server2.setHostName(address);
            server2.setHost(this.dummyHost);
            servers.add(server2);

            context.getInspectionContext().discovered(server);
            context.getInspectionContext().discovered(server2);

            return SUCCESS;
        }

        @Override
        public int getOrder() {
            return 10;
        }
    }

    class DummyInspectionStep2 implements Step {

        DummyHost dummyHost;

        public DummyInspectionStep2(DummyHost dummyHost) {
            this.dummyHost = dummyHost;
        }

        @Override
        public String getDescription() {
            return "Inspecting DummyJeeQueue on " + getId();
        }

        @Override
        public StepExitCode execute(ExecutionContext context) throws Exception {

            setOs("hoefnix");
            setAccessMethod("ssh");

            DummyJeeQueue queue = new DummyJeeQueue();
            queue.setId(getId() + "/DummyJeeQueue3");
            queue.setHost(this.dummyHost);

            context.getInspectionContext().discovered(queue);
            context.getInspectionContext().inspected(queue);

            return SUCCESS;
        }

        @Override
        public int getOrder() {
            return 20;
        }

    }
}
