/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.v3.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.test.v3.DummyContainer;

public abstract class TestStep
implements Step {
    protected int stepDelay;
    protected int logAmountInKb;
    protected DummyContainer dummyContainer;

    public TestStep(DummyContainer dummyContainer) {
        if (dummyContainer.getStepDelayTimeInMilliSeconds() < 1) {
            throw new RuntimeException("stepDelayTimeInMilliSeconds retrieved from a test CI of type " + String.valueOf(((Object)((Object)dummyContainer)).getClass()) + " is less then 1");
        }
        this.dummyContainer = dummyContainer;
        this.stepDelay = dummyContainer.getStepDelayTimeInMilliSeconds();
        this.logAmountInKb = dummyContainer.getAmountOfKBLogFiles();
    }

    public TestStep(int stepDelay, int logAmountInKb) {
        this.stepDelay = stepDelay;
        this.logAmountInKb = logAmountInKb;
    }

    public StepExitCode execute(ExecutionContext ctx) {
        int sleepMillis = 100;
        int amountOfSleeps = this.stepDelay / 100;
        int bytesOfLogToGeneratePerSleep = this.logAmountInKb * 1000 / amountOfSleeps;
        try {
            for (int i = 0; i < amountOfSleeps; ++i) {
                Thread.sleep(100L);
                ctx.logOutput(TestStep.generateLog(bytesOfLogToGeneratePerSleep));
            }
        }
        catch (InterruptedException e) {
            ctx.logError("Thread.sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }
        return StepExitCode.SUCCESS;
    }

    private static String generateLog(int bytes) {
        String hundredBytes = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam lacinia odio in dui sollicitudin ...\n";
        StringBuilder sb = new StringBuilder();
        sb.append(bytes).append(" bytes: ");
        for (int i = 0; i < bytes / 100; ++i) {
            sb.append(hundredBytes);
        }
        return sb.toString();
    }
}

