package com.xebialabs.deployit.plugin.test.yak.ci;

import java.io.File;
import java.util.List;

import com.google.common.collect.Lists;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class StartableContainer extends BaseContainer {

    @Property
    private String tempDir;

    @Property
    private String startFileName;

    @Property(description = "Amount of time in milliseconds each step will wait before continuing")
    private int stepDelayTimeInMilliSeconds = 3000;


    @ControlTask(label = "Start", description = "Start the test server.")
    public List<Step> start() {
        Step step = new Step() {

            @Override
            public String getDescription() {
                return "Start the test server.";
            }

            @Override
            public StepExitCode execute(ExecutionContext ctx) throws Exception {
                new File(tempDir, startFileName).createNewFile();
                return StepExitCode.SUCCESS;
            }

            @Override
            public int getOrder() {
                return Step.DEFAULT_ORDER;
            }
        };
        return Lists.newArrayList(step);
    }

    @ControlTask(label = "Stop", description = "Stop the test server.")
    public List<Step> stop() {
        Step step = new Step() {

            @Override
            public String getDescription() {
                return "Stop the test server.";
            }

            @Override
            public StepExitCode execute(ExecutionContext ctx) throws Exception {
                for (int i = 0; i < stepDelayTimeInMilliSeconds/100; i++) {
                    Thread.sleep(100);
                }
                return StepExitCode.SUCCESS;
            }

            @Override
            public int getOrder() {
                return Step.DEFAULT_ORDER;
            }
        };
        return Lists.newArrayList(step);
    }

    @ControlTask(label = "Resume", description = "Resume the test server.")
    public List<Step> resume() {
        Step step = new Step() {

            @Override
            public String getDescription() {
                return "Resume the test server.";
            }

            @Override
            public StepExitCode execute(ExecutionContext ctx) throws Exception {
                for (int i = 0; i < stepDelayTimeInMilliSeconds/100; i++) {
                    Thread.sleep(100);
                }
                for (int i = 0; i < 100; i++){
                    ctx.logError("Failed to resume the task.");
                }
                return StepExitCode.FAIL;
            }

            @Override
            public int getOrder() {
                return Step.DEFAULT_ORDER;
            }
        };
        return Lists.newArrayList(step);
    }

    public int getStepDelayTimeInMilliSeconds() {
        return stepDelayTimeInMilliSeconds;
    }

    public void setStepDelayTimeInMilliSeconds(int stepDelayTimeInSeconds) {
        this.stepDelayTimeInMilliSeconds = stepDelayTimeInSeconds;
    }
}
