package com.xebialabs.deployit.plugin.test.v3.step;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.test.v3.VirtualEnvironment;

import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
public class DestroyVirtualEnvironmentStep implements Step {

    private final String environmentId;

    public DestroyVirtualEnvironmentStep(final String environmentId){
        this.environmentId = environmentId;
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getDescription() {
        return "Deleting environment and instances of " + environmentId;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        try {
            Repository repository = ctx.getRepository();

            VirtualEnvironment environment = repository.read(environmentId);

            Set<String> instanceIds = newHashSet();
            Set<Host> instances = environment.getLinkedHosts();
            for (ConfigurationItem instance : instances) {
                instanceIds.add(instance.getId());
            }
            ctx.logOutput("Deleting Environment: " + environmentId);
            repository.delete(environmentId);

            for(String id : instanceIds){
                ctx.logOutput("Deleting instance: " + id);
                repository.delete(id);
            }

            return StepExitCode.SUCCESS;
        } catch(Exception e){
            ctx.logError("Exception while trying to delete environment", e);
            return StepExitCode.FAIL;
        }
    }
}
