package com.xebialabs.deployit.plugin.test.v3;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;
import com.xebialabs.deployit.plugin.test.v3.step.DestroyVirtualEnvironmentStep;

import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings("serial")
@Metadata(description = "Environment which can contain cloud hosts", root = Metadata.ConfigurationItemRoot.ENVIRONMENTS)
public class VirtualEnvironment extends Environment {

    @ControlTask
    public List<Step> destroy(final TemplateParameters params) {
        return newArrayList((Step) new DestroyVirtualEnvironmentStep(this.getId()));
    }

}