package com.xebialabs.deployit.plugin.test.yak.ci;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.test.yak.step.StartYakServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.StopYakServerStep;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
public class YakServer extends BaseContainer {

    @Property(required = false, defaultValue = "")
    Host host;
    public Host getHost() {
        return host;
    }

    public void setHost(Host host) {
        this.host = host;
    }


    @Contributor
    public static void restartYakServers(Deltas deltas, DeploymentPlanningContext result) {
        for (YakServer yakServer : serversRequiringRestart(deltas.getDeltas())) {
            result.addStep(new StopYakServerStep(yakServer));
            result.addStep(new StartYakServerStep(yakServer));
        }
    }

    private static Set<YakServer> serversRequiringRestart(List<Delta> operations) {
        Set<YakServer> servers = new TreeSet<>();
        for (Delta operation : operations) {
            if (operation.getDeployed() instanceof RestartRequiringDeployedYakFile && operation.getDeployed().getContainer() instanceof YakServer) {
                servers.add((YakServer) operation.getDeployed().getContainer());
            }
        }
        return servers;
    }
}
