package com.xebialabs.deployit.plugin.test.v3.step;

import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.test.v3.DummyContainer;

public class TestCreateStepWithArtifact extends TestCreateStep implements StageableStep {

    private Artifact artifact;

    public TestCreateStepWithArtifact(DummyContainer dummyContainer, Artifact artifact, int stepNr) {
        super(dummyContainer, stepNr);
        this.artifact = artifact;
        if (dummyContainer.getStepDelayTimeInMilliSeconds() < 1) {
            throw new RuntimeException("stepDelayTimeInMilliSeconds retrieved from a test CI of type " + dummyContainer.getClass() + " is less then 1");
        }
    }

    public void requestStaging(StagingContext ctx) {
        ctx.stageArtifact(artifact, dummyContainer);
    }

}
