package com.xebialabs.deployit.plugin.test.v3;

import java.util.Set;

import com.xebialabs.deployit.plugin.test.v3.step.FailingCreateStep;
import com.xebialabs.deployit.plugin.test.v3.step.TestCreateStepWithArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Property.Size;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.test.v3.step.TestDestroyStep;

@SuppressWarnings("serial")
public class DummyJeeServerDeployedEar extends BaseDeployedArtifact<DummyEar, DummyJeeServer> {

    @Property(required = false)
    private Set<String> dummySetOfStrings;

    @Property(required = false, size = Size.LARGE)
    private String property0;
    
    @Property(required = false, category= "Tab1")
    private String property1;
    
    @Property(required = false, category= "Tab1")
    private String property2;
    
    @Property(required = false, category= "Tab2")
    private String property3;
    
    @Property(required = false, category= "Tab2")
    private String property4;
    
    @Property(required = false, category= "Tab3")
    private String property5;
    
    @Property(required = false, category= "Tab3")
    private String property6;
    
    @Property(required=false)
    private HostDeployedConfigurationFiles hostDeployedConfigurationFiles;
    

    @Create
    public void deploy(DeploymentPlanningContext result) {
        boolean willFail = getDeployable().getFailToDeployOnDummyJeeServer();
        logger.info(getDeployable().getName() + " step fail: " + willFail);
        for (int i = 0; i < getContainer().getNumberOfSteps(); i++) {
            if (willFail) {
                result.addStep(new FailingCreateStep(getContainer(), i));
            } else {
                result.addStep(new TestCreateStepWithArtifact(getContainer(), getDeployable(), i));
            }
        }
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result) {
        destroy(result);
        deploy(result);
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result) {
        for (int i = 0; i < getContainer().getNumberOfSteps(); i++) {
            result.addStep(new TestDestroyStep(getContainer(), i));
        }
    }
    
    public String getProperty0() {
        return property0;
    }
    
    public void setProperty0(String property0) {
        this.property0 = property0;
    }
    
    public String getProperty1() {
        return property1;
    }
    
    public void setProperty1(String property1) {
        this.property1 = property1;
    }
    
    public String getProperty2() {
        return property2;
    }
    
    public void setProperty2(String property2) {
        this.property2 = property2;
    }
    
    public String getProperty3() {
        return property3;
    }
    
    public void setProperty3(String property3) {
        this.property3 = property3;
    }
    
    public String getProperty4() {
        return property4;
    }
    
    public void setProperty4(String property4) {
        this.property4 = property4;
    }
    
    public String getProperty5() {
        return property5;
    }
    
    public void setProperty5(String property5) {
        this.property5 = property5;
    }
    
    public String getProperty6() {
        return property6;
    }
    
    public void setProperty6(String property6) {
        this.property6 = property6;
    }

    public Set<String> getDummySetOfStrings() {
        return dummySetOfStrings;
    }

    public void setDummySetOfStrings(Set<String> dummySetOfStrings) {
        this.dummySetOfStrings = dummySetOfStrings;
    }

    public HostDeployedConfigurationFiles getHostDeployedConfigurationFiles() {
        return hostDeployedConfigurationFiles;
    }
    
    public void setHostDeployedConfigurationFiles(
            HostDeployedConfigurationFiles hostDeployedConfigurationFiles) {
        this.hostDeployedConfigurationFiles = hostDeployedConfigurationFiles;
    }

    @SuppressWarnings("unused")
    private static final Logger logger = LoggerFactory.getLogger(DummyJeeServerDeployedEar.class);

}
