package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.test.yak.ci.DeployedYakStitchFile;

@SuppressWarnings("serial")
public class StartDeployedYakStitchFileStep implements Step {

    private DeployedYakStitchFile deployedYakStitchFile;

    public StartDeployedYakStitchFileStep(DeployedYakStitchFile deployedYakStitchFile) {
        this.deployedYakStitchFile = deployedYakStitchFile;
    }

    @Override
    public String getDescription() {
        return "Starting " + deployedYakStitchFile;
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        if(deployedYakStitchFile.hasUnresolvedPlaceholders(ctx)) {
            return StepExitCode.FAIL;
        } else {
            return StepExitCode.SUCCESS;
        }
    }

    @Override
    public int getOrder() {
        return 90;
    }
}
