package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.deployment.planning.Checkpoint;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.step.FirstTimePauseStep;
import com.xebialabs.deployit.plugin.test.yak.step.GrazingStep;
import com.xebialabs.deployit.plugin.test.yak.step.StableStep;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class GrazingYakHerd extends BaseDeployed<YakHerdWithIntermediateCheckpoints, Meadow> {

    @Property
    private List<String> yaks = newArrayList();

    @Create
    public void toMeadow(DeploymentPlanningContext context, Delta delta) {
        for (String yak : yaks) {
            GrazingStep grazingStep = new GrazingStep(yak, getContainer());
            Checkpoint cp = new Checkpoint(delta, yak, null);
            context.addStepWithCheckpoint(grazingStep, cp);
            // Pause after every yak, so that we can rollback
            context.addStep(new FirstTimePauseStep(grazingStep.getOrder()));
        }
    }

    @Destroy
    public void toStable(DeploymentPlanningContext context, Delta delta) {
        List<String> intermediateCheckpoints = delta.getIntermediateCheckpoints();
        for (String yak : yaks) {
            if (intermediateCheckpoints.contains(yak) || intermediateCheckpoints.isEmpty()) {
                StableStep stableStep = new StableStep(yak, getContainer());
                Checkpoint cp = new Checkpoint(delta, yak, null);
                context.addStepWithCheckpoint(stableStep, cp);
            }
        }
    }
}
