/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.v3.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.test.v3.DummyEnvironmentTemplate;
import com.xebialabs.deployit.plugin.test.v3.VirtualEnvironment;
import java.util.Set;

public class CreateVirtualEnvironmentStep
implements Step {
    private final String environmentId;
    private final DummyEnvironmentTemplate template;

    public CreateVirtualEnvironmentStep(String environmentId, DummyEnvironmentTemplate dummyEnvironmentTemplate) {
        this.environmentId = environmentId;
        this.template = dummyEnvironmentTemplate;
    }

    public int getOrder() {
        return 40;
    }

    public String getDescription() {
        return "Creating environment: " + this.environmentId;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            ctx.logOutput("creating environment " + this.environmentId);
            Repository repository = ctx.getRepository();
            VirtualEnvironment environment = (VirtualEnvironment)Type.valueOf(VirtualEnvironment.class).getDescriptor().newInstance(this.environmentId);
            environment.setTemplate(this.template);
            environment.setLinkedCis((Set)ctx.getAttribute("hosts"));
            repository.create((ConfigurationItem[])new VirtualEnvironment[]{environment});
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            ctx.logError("Exception while trying to create environment", (Throwable)e);
            return StepExitCode.FAIL;
        }
    }
}

